# Gotchas:
# $xyx, $(xyz), ${xyz} and %xyx indicate variables to be replaced at runtime, please do NOT translate variable names
# & in button labels such as accessibility denotes the quick access letter
# buttons are fixed in length, so please make sure the translated strings will fit

# MAIN PAGE
LangString UseCD ${LANG_GERMAN} "(CD verwenden)"
LangString ReadOnly ${LANG_GERMAN} "(Nur lesen)"
LangString MainHeaderSubText ${LANG_GERMAN} "Bitte whlen Sie einen Benutzernamen und ein Passwort fr das neue Konto"
LangString MainLanguageLabel ${LANG_GERMAN} "Sprache:"
LangString MainUsernameLabel ${LANG_GERMAN} "Benutzername:"
LangString MainPasswordLabel ${LANG_GERMAN} "Passwort:"
LangString MainInstallationSizeLabel ${LANG_GERMAN} "Gre der Installation (GB):"
LangString MainDistroLabel ${LANG_GERMAN} "Desktop-Umgebung:"
LangString MainInstallationDriveLabel ${LANG_GERMAN} "Installationslaufwerk ($freeSpace GB frei);"

# TOOLTIPS
LangString MainLanguageToolTip ${LANG_GERMAN} "Installationssprache:"
LangString MainUsernameToolTip ${LANG_GERMAN} "Bitte whlen Sie einen Benutzernamen fr das neue Konto:$\r$\nEr mu aus Kleinbuchstaben bestehen.$\r$\nEr darf keine Leerzeichen enthalten.$\r$\nEr darf nur Standardzeichen und Zahlen enthalten.$\r$\nEr darf nicht mit einer Nummer beginnen."
LangString MainPasswordToolTip ${LANG_GERMAN} "Bitte whlen Sie ein Passwort fr das neue Konto.$\r$\nEs darf keine Leerzeichen enthalten."
LangString MainInstallationSizeToolTip ${LANG_GERMAN} "Wie viele Gb wollen Sie verwenden?$\r$\n4 GB sind das absolute Minimum,$\r$\n8 GB sind sinnvoll."
LangString MainInstallationDriveToolTip ${LANG_GERMAN} "Auf welchem Laufwerk wollen Sie die Installation durchfhren?$\r$\nDas Laufwerk sollte ber mindestens 5 GB freien Plattenplatz verfgen."
LangString Distro1ToolTip ${LANG_GERMAN} "Ubuntu ist die Grundeinstellung."
LangString Distro2ToolTip ${LANG_GERMAN} "Kubuntu verwendet die KDE-3.5-Oberflche"
LangString Distro3ToolTip ${LANG_GERMAN} "Kubuntu+KDE4 verwendet die KDE-4-Oberflche."
LangString Distro4ToolTip ${LANG_GERMAN} "Xubuntu eignet sich fr ltere Rechner"
LangString MainDistroToolTip ${LANG_GERMAN} "Welche grafische Umgebung wollen Sie installieren?$\r$\n* $(Distro1ToolTip)$\r$\n* $(Distro2ToolTip)$\r$\n* $(Distro3ToolTip)$\r$\n* $(Distro4ToolTip)"

# ERRORS
LangString ErrorNoUsername ${LANG_GERMAN} "Bitte einen gltigen Benutzernamen eingeben"
LangString ErrorSpaceInUsername ${LANG_GERMAN} "Bitte keine Leerzeichen im Benutzernamen verwenden."
LangString ErrorUsernameUpperCase ${LANG_GERMAN} "Bitte den Benutzernamen nur in Kleinbuchstaben schreiben."
LangString ErrorUsernameFirstCharNotLetter ${LANG_GERMAN} "Ihr Benutzername muss mit einem Buchstaben beginnen."
LangString ErrorUsernameIllegalChars ${LANG_GERMAN} "Der Benutzername darf nur Standardbuchstaben und Zahlen enthalten."
LangString ErrorReservedUsername ${LANG_GERMAN} "The selected username is reserved, please selected a different one."
LangString ErrorNoPassword ${LANG_GERMAN} "Bitte geben Sie ein korrektes Passwort ein."
LangString ErrorPasswordMismatch ${LANG_GERMAN} "Die Passwrter stimmen nicht berein."
LangString ErrorSpaceInPassword ${LANG_GERMAN} "Bitte benutzen Sie keine Leerzeichen im Passwort."
LangString ErrorNoFreeSpace ${LANG_GERMAN} "Nicht gengend Speicherplatz fr eine Neuinstallation"
LangString ErrorNoKernel ${LANG_GERMAN} "Could not retrieve some essential files"
LangString ErrorBcdedit ${LANG_GERMAN} "Fehler beim Ausfhren:"
LangString ErrorWubibcd ${LANG_GERMAN} "Fehler beim Ausfhren:"
LangString ErrorCD2ISO ${LANG_GERMAN} "Could not access the CD, please make sure other applications are not using it and try again"
LangString ErrorDownload ${LANG_GERMAN} "Der Download wurde mit folgendem Fehler abgebrochen:"
LangString ErrorNoCD ${LANG_GERMAN} "Could not find any appropriate CD"
LangString ErrorNoAdmin ${LANG_GERMAN} "You must be logged in as administrator!"
LangString ErrorNoMemory ${LANG_GERMAN} "You need at least ${MinMemoryMB}MB of memory to run the installer!"

# INSTALLER
LangString AboutToInstall ${LANG_GERMAN} "You are about to install $Distro-$DistroVersion"
LangString InstallHeaderInitializing ${LANG_GERMAN} "Installing $Distro-$DistroVersion"
LangString InstallSubHeader ${LANG_GERMAN} "Bitte warten, whrend die Dateien empfangen und vorbereitet werden"
LangString InstallHeaderUncompressWubifolder ${LANG_GERMAN} "Entpacke wubi Ordner . . ."
LangString InstallHeaderCopyIso ${LANG_GERMAN} "Kopiere Installationsdateien . . ."
LangString InstallHeaderDownload ${LANG_GERMAN} "Holen der Installationsdateien, Wiederaufnahme ist mglich"
LangString InstallHeaderBackupIso ${LANG_GERMAN} "Sichere Installations-Dateien . . ."
LangString InstallHeaderWritePreseed ${LANG_GERMAN} "Writing configuration files..."
LangString InstallHeaderWriteUninstaller ${LANG_GERMAN} "Richte Installer ein . . ."
LangString InstallHeaderWriteBootLoader ${LANG_GERMAN} "Einrichten des Bootloaders..."
LangString InstallGenerateVirtualDisks ${LANG_GERMAN} "Virtuelle Festplatten werden erstellt..."
LangString InstallCopyFiles ${LANG_GERMAN} "Kopiere Installationsdateien . . ."
LangString InstallCreateFolders ${LANG_GERMAN} "Virtuelle Festplatten werden erstellt..."
LangString InstallRetrieveIso ${LANG_GERMAN} "Retrieving installation files."

# UNINSTALLER
LangString UninstallAlreadyInstalled ${LANG_GERMAN} "wurde bereits installiert"
LangString UninstallAsk ${LANG_GERMAN} "Do you want to uninstall it?"
LangString UninstallMessageField ${LANG_GERMAN} "$OldInstallationDrive\${DefaultInstallationDir} will be uninstalled.$\r$\nYou can backup your files if you want."
LangString UninstallBackupIsoCheckBox ${LANG_GERMAN} "Backup der heruntergeladenen Dateien"
LangString UninstallBackupHomeCheckBox ${LANG_GERMAN} "Backup personal documents (home.disk)."
LangString UninstallBackupLocationField ${LANG_GERMAN} "Backup location: $BackupFolder"

# FINISH
LangString EjectRebootMsg ${LANG_GERMAN} "Please remove any CD/DVD and reboot to complete the installation."
LangString RebootMsg ${LANG_GERMAN} "Sie mssen Ihr System neu starten um die Installation abzuschliessen."

# DOWNLOADER
LangString MetadlDownloading ${LANG_GERMAN} "Downloading installation files..."
LangString MetadlChecking ${LANG_GERMAN} "Checking installation files..."
LangString MetadlConnecting ${LANG_GERMAN} "Verbinde zu %s..."
LangString MetadlInitializing ${LANG_GERMAN} "Initializing..."
LangString MetadlChecksums ${LANG_GERMAN} "Berechne Prfsumme..."
LangString MetadlRetrying1 ${LANG_GERMAN} "Erneuter Versuch in %d Sekunden... (%d von %d)"
LangString MetadlRetrying2 ${LANG_GERMAN} "Erneuter Versuch in %d Sekunden..."
LangString MetadlSecond ${LANG_GERMAN} "Zweite(r)"
LangString MetadlSeconds ${LANG_GERMAN} "Sekunden"
LangString MetadlProgress ${LANG_GERMAN} "%s (%d%%) von %s @ %s/s"
LangString MetadlRemaining ${LANG_GERMAN} " (%s brig)"
LangString PleaseConnect ${LANG_GERMAN} "Bitte stellen Sie jetzt eine Verbindung mit dem Internet her."

# ACCESSIBILITY
LangString MobilityAids ${LANG_GERMAN} "Mobility Aids"
LangString VisibilityAids ${LANG_GERMAN} "Visibility Aids"
LangString AccessibilityButton ${LANG_GERMAN} "&Accessibility"
LangString AccessibilityText ${LANG_GERMAN} "Accessibility profile"
LangString AccessibilitySubText ${LANG_GERMAN} "Please select the appropriate accessibility profile"
LangString NoAccessibility ${LANG_GERMAN} "None"
LangString VisibilityHighContrast ${LANG_GERMAN} "High Contrast"
LangString VisibilityMagnifier ${LANG_GERMAN} "Magnifier"
LangString VisibilityScreenReader ${LANG_GERMAN} "Screen Reader"
LangString VisibilityBraille ${LANG_GERMAN} "Braille Terminal"
LangString MobilityKeyboardModifiers ${LANG_GERMAN} "Keyboard Modifiers"
LangString MobilityOnScreenKeyboard ${LANG_GERMAN} "On-Screen Keyboard"

# CDBOOT
LangString CDBootTitle ${LANG_GERMAN} "Install CD booter"
LangString CDBootText ${LANG_GERMAN} "If your machine cannot boot off the CD, this program will install a new boot menu entry to help you boot from CD. In most cases this program is not needed, and it is sufficient to reboot with the CD-Rom in the tray.$\r$\n$\r$\nDo you want to proceed and install the CD booter?"

# BOOTMENU
LangString BootMenuNormal ${LANG_GERMAN} "Start installer in normal mode"
LangString BootMenuSafeGraphics ${LANG_GERMAN} "Start installer in safe graphic mode (only if you have display problems)"
LangString BootMenuACPI ${LANG_GERMAN} "Start installer with ACPI workarounds (only if you have ACPI problems)"
LangString BootMenuVerbose ${LANG_GERMAN} "Start installer in verbose mode"

# FAILURE-COMMAND
LangString FailureCommand ${LANG_GERMAN} "The installation failed. Logs have been saved in: $INSTDIR\installation-logs.zip.$\r$\n$\r$\nNote that in verbose mode, the logs may include the password.$\r$\n$\r$\nThe system will now reboot."
