﻿# coding=UTF-8
# -*- coding: UTF-8 -*-
import string, re
import os
import codecs
import pprint

import mylibs
import configs
targetos = 'l' #configs.targetos
targetbrowser = configs.targetbrowser

pages = configs.pages 
pagenames = configs.pagenames
langs = configs.langs 
default_lang = configs.default_lang

#targetbrowser = 'firefox' # or 'kmeleon'  # overide -

# ----------- cache Installable files paths --------
file_mask = r'.*\.(msi|exe|bat|zip|7z|jar)'
mask_re = re.compile(file_mask)


lch_path = "../lch/";
lch_tpl = '''[Launch]
ExecuteFile=${cwd}$pathtofile''';

url_redirect_tpl = '''
<html><head>
<meta http-equiv="refresh" content="0;url=$url">
</head><body></body></html>
'''

url_lch_tpl = '''
[Launch]
ExecuteFile=$url
''' ##ExecuteParameter=${cwd}$parameter

#---Label---#000000#FFFFFF------------------------------------------------------
generator_start_node_installs = '../../../Programos/';
#lch_start_node_installs = '..\\Programos\\'; # launcheriui reikia paduoti tik ..\\Programos , nes jis skaiciuoja nuo \bin\ katalogo
lch_start_node_html = '../autorun/html/'; # launcheriui reikia paduoti tik ..\\Programos , nes jis skaiciuoja nuo \bin\ katalogo
installable_files = []
installable_files_used = []
new_lch_list = []

img_root = "../images/icons/mokslui/final-h40/"
img_fnames = []
re_img = re.compile(r'.*\.(png|gif|jpg)')
proglist = []

import mylibs
getftext = mylibs.getftext
putftext = mylibs.putftext
putftextU = mylibs.putftextU
fileExists = mylibs.fileExists

exclude_dirs = 'Gimp/Portatyvus/App'.split(';')
def has_fragment(dir):
    res = False
    ##dir = dir.replace('\\', '/')
    for fragment in exclude_dirs:
        if dir.find(fragment) > -1:
            res = True
    return res

def callback_scan(arg, directory, files):
    for file in files:
        if mask_re.match(file) and not has_fragment(directory):
            full_path = os.path.join(directory, file)
            installable_files.append(full_path.replace('\\', '/'))
os.path.walk(generator_start_node_installs, callback_scan, file_mask)


##def callback_scan_imgs(arg, directory, files):
##    for file in files:
##        if mask_re.match(file) : img_fnames.append(file.lower().replace('\\', '/'))
###os.path.walk('../' + img_root, callback_scan_imgs, re_img)
img_fnames = os.listdir(os.path.abspath( img_root))

def look_for_install_file(fname_fragment):
    found = False
    fname_fragment = fname_fragment.lower()
    for file_path in installable_files:
       fname = file_path.split('/')[-1]
       #if re.compile(fcodename).search(fname):
       if fname.lower().find(fname_fragment) != -1:
           found = True
           installable_files_used.append(file_path)
           return file_path
    return False

found_imgs = []
def imgExists(fname):
    for img in img_fnames:
        if img.lower() == fname.lower():
            found_imgs.append (img)
            return img
    return ''    


## handle links..
linkify2 = re.compile(r'\[\[http(://[^ \t]+) +(.*?)\]\]')
linkify1 = re.compile(r'http://([^ \t]+)')
linkify_local = re.compile(r'\[\[([^ \t]+) +(.*?)\]\]')
linkify_kmeleon = re.compile(r'("http://[^"]+")|(\'http://[^\']+\')')
#linkify_kmeleon = re.compile(r'"(http://[^"]+)"')
forbiden_in_fname = re.compile (r'[%\?\!:\'\"\\\(\)\=\& ]+')


spec4win = re.compile(r'<win>(.+?)</win>')
spec4lin = re.compile(r'<lin>(.+?)</lin>')
spec4allos = re.compile(r'<altinfo>(.+?)</altinfo>')

def filter_os(src):
    rez = src
    if targetos == 'w':  rez = spec4win .sub('\\1', rez) ;     rez = spec4lin .sub('', rez) ;        rez = spec4allos .sub('', rez) ;
    elif targetos == 'l':  rez = spec4win .sub('', rez) ;          rez = spec4lin .sub('\\1', rez) ;   rez = spec4allos .sub('', rez) ;
    else:  rez = spec4win .sub('', rez) ;           rez = spec4lin .sub('', rez) ;        rez = spec4allos .sub('\\1', rez) ;
    return rez

def filter_linkify(src):
    rez = src
    #if targetbrowser == 'firefox':
    rez = linkify2.sub('<a href="http_\\1">\\2</a>', rez)
    rez = linkify_local.sub('<a href="\\1">\\2</a>', rez)
    rez = linkify1.sub('<a href="http://\\1">\\1</a>', rez)
    rez = rez.replace('http_', 'http')
    rez = filter_linkify_4kmeleon(rez)
    return rez

def clean_url4fname (url):
    rez = forbiden_in_fname.sub('', url)
    rez = rez.replace('/', '__').strip(' _')
    if rez[0:8] == 'http____': rez = rez[8:]
    return rez


def linkify_4kmeleon(url):
    if targetbrowser == 'kmeleon':
        url2fname = clean_url4fname(url)
    ## !!! LAbai svarbu nekurti labai ilgu vardu - max 63 simboliai, nes paskui CD/DVD gali Windai neskaityt
        ##htmlfname = 'external/'+url2fname+'.redirect.html'
        lchfname = lch_path+'external/'+ url2fname + '.lch'
        ##putftext(htmlfname, url_redirect_tpl.replace('$url', url))
        url_lch_txt = url_lch_tpl.replace('$url', url)  ##lch_start_node_html+htmlfname
        putftext(lchfname, url_lch_txt)
        rezurl = lchfname
    ##elif targetbrowser == 'welcomecenter':
     ##   rezurl = url
    else: rezurl = url
    return rezurl

def filter_linkify_4kmeleon(src):
    rez = src
    if targetbrowser == 'kmeleon':
        ##rez = linkify_kmeleon.sub( '"external/' + clean_url4fname('\\1') + '.lch"', src)
        for match in re.finditer(linkify_kmeleon, src):
            url = match.group(0).strip('\'"')
            lchfname = linkify_4kmeleon(url)
            rez = rez.replace(url, lchfname)
##            url2fname = clean_url4fname(url)
##            htmlfname = 'external/'+url2fname+'.redirect.html'
##            putftext(htmlfname, url_redirect_tpl.replace('$url', url))
##            url_lch_txt = lch_tpl.replace('$pathtofile', lch_start_node_html+htmlfname)
##            putftext(lch_path+'external/'+ url2fname + '.lch', url_lch_txt)
    ##elif targetbrowser == 'welcomecenter':
    return rez

## map program names to file names on disk
letters_lt    = u'ąčęėįšųūžĄČĘĖĮŠŲŪŽ'
letters_latin = 'aceeisuuzACEEISUUZ'
def latinize(str):
    ##print str
    for i in range(len(letters_latin)):
        ##print (letters_lt[i], letters_latin[i])
        str = str.replace(letters_lt[i], letters_latin[i])
    str = re.sub('[^\w ()-_]+', '', str)
    str = re.sub('\s+', '-', str)
    ##str = re.sub('[_-]{2,5}', '-', str)
    return str.encode('ascii', 'ignore').strip('- _')
## --------------

def listofdict_filterkey(listofdict, key):
    reslist = []
    for d in listofdict:
        reslist.append(d[key])
    return reslist    


def sortlist(listofdict, key):
##    newdict = {}
##    index =[]
    n = len(listofdict)
    for i  in range(n):
        for j in range(i, n):
            if listofdict[i][key] > listofdict[i][key]:
                listofdict[i], listofdict[j] = listofdict[j], listofdict[i]
##    for a in listofdict:
##        ##index.append(key)
##        newdict[key] = a
    return listofdict    

def _(str):
    return  str;   
    ## TODO: endof functions

# ----------- get Program Description list ----
##f = open ('src.txt') #( 'programu_mokslui_sarasas.csv' )
f = codecs.open('src.txt', encoding='utf-8')
lines = f.readlines()
f.close()
_imgextraformat = ' border="0" align="right"'
filter_brackets_re = re.compile( '\(.*?\)')

for a in range(50):  print " "
# ------------- Parse the list
print 'START'
outlist = {}

for lang in ['en'] : # in langs:          #TODO: main loop
    outlist[lang] = []
    for pi in range(len(pages)):
        page = pages[pi]
        pageName = pagenames[pi]
        if pages[pi] == '-': pageName = '__just_4generating_some_lch'
        ## init vals
        _prev_header = ''
        out = ""
        out_cat = ''
        
        pagecatlist = []
        category_progs = []
        category_out = ''
        packages_main = []
        packages_recommended = []
        packages_suggested = []

        catname_last  = '' # to trigger the change of category in search-list

        for line in lines[1:]:
            inputline2list = re.split(r'\t', line)[:29]
            #fields = 'os, technology, importance, licence, usefor, catname, progname, linuxrun,  installfname, eninstallfname, progwww, enprogwww, devs, localised, about, moreinfo, morehtml, comments, shortcommings, targetgroup, firststeps, enabout'.split(', ')
            fields1 = 'usefor, catname, progname, _progname, progwww, localised, importance'
            fields2 = 'os'
            fields_extra = 'downloadwww'
            fields_loc = 'progwww, localised'
            os, technology, importance, licence, usefor, catname, progname, linpackagename, linrecommends, linsuggests  , linuxrun,  installfname, windirectrun, eninstallfname, progwww, enprogwww, downloadwww, endownloadwww, lessonswww, enlessonswww, localised, about, moreinfo, morehtml, comments, shortcommings, targetgroup, firststeps, enabout = inputline2list
          
            abouts = {}
            catnames = {}
            progwwws = {}
            installfnames = {}
            downloadwwws = {}
            lessonswwws = {}
            
            os_alternatives_raw = os
            os = os.split('/')[0]  ## untested are separated with /
            os = os.split('?')[0]
            
            _catnames =  catname.split('|')         ##get/split/prepair languages info
            if len(_catnames) > 1: 
                catnames['lt'], catnames['en'] = _catnames[:len(langs)]
            else: catnames['lt'] = _catnames[0].strip();  catnames['en'] = catnames['lt']

            
            catname = catnames[lang]
            #end bridging multilang
            
            if string.strip (catname) != '' and catname.strip() != '!!!':
                if len(category_progs) > 0:   #if there are programs in category
                    out += category_out
                    pagecatlist.append(catname_current);             #give rendered contents (if there are any)
                category_progs = []
                catname_current = string.strip(catname) 
                category_out = "\n\n= " +  catname_current + " =\n"
                


            
            page_right = 0  ## checks if program fits for this html-page, which is now being generated
            if usefor.find('/')  > -1:
                usefor = usefor.split('/')[0];
                for i in range(len(usefor) ):
                    if page.find(usefor[i] ) > -1: page_right = 1
            elif len(usefor) > 0 and page.find(usefor[0] ) > -1:  page_right = 1
            if (os.find('l') !=-1) and linpackagename !='?'and progname.strip() != '' and catname.strip() != '!!!' \
                and page_right and ( importance.strip() != '' and int(importance) > configs.importance_level):
                if    page_right :  ## junk question  (page.find(usefor[0] ) > -1)  	                #_progname = string.split('-', line)[:1]  ## test
                    progname4work = filter_brackets_re.sub('', progname)
                    _progname = latinize(progname4work)
                    _progname = _progname.strip(' -').lower()
                    _progname = re.sub(r'[ -]+', '-', _progname )
                    category_progs.append(_progname)
                    
                    ## GEN METAPACKAGE
                    ##linpackagename	linrecommends	linsugests
                    if True:   #just to mark the block :)
                        linpackagename = linpackagename.strip()
                        if linpackagename=='' or  linpackagename=='_': linpackagename += _progname.lower().strip()
                            #if (linpackagename in ['', '-'] ):	                    linpackagename = progname4work;    
                        category_out += '\n * ' + linpackagename # +'\n# Package '
                        packages_main += [linpackagename]
                        linsuggests_list = linsuggests.strip( ' -').split('---')
                        ##linsuggests_list = [  s.replace('(NETINKAMAS)', '').strip()  for s in linsuggests_list]  ## strip comments about compatibility
                        linsuggests_list = [filter_brackets_re.sub(  '', s).strip()  for s in linsuggests_list]  ## strip things in brackets
                        packages_suggested += linsuggests_list
                        linsuggests_list = [ "(%s)     #suggests"% packet   for packet in linsuggests_list]  
                        if linsuggests:  category_out += '\n * ' + '\n * '.join(linsuggests_list)

                        linrecommends_list = linrecommends.strip( ' -').split('---')
                        linrecommends_list = [filter_brackets_re.sub(  '', s).strip()  for s in linrecommends_list]  ## strip things in brackets
                        packages_recommended += linrecommends_list
                        linrecommends_list = [ "(%s)     #recommends"% packet   for packet in linrecommends_list]  
                        if linrecommends:  category_out += '\n * ' + '\n * '.join(linrecommends_list) 
                        #category_out += '\n'
                        
                    if catname_last != catname_current: 
                            #outli_html = "<h2>%s</h2>" % catname_current + outli_html
                            catname_last = catname_current
            
        if len(category_progs) > 0: out += category_out   #print last category          #give rendered contents (if there are any)
        #print '#'+lang
        print '#=== ' + pageName + ' ===>'+   out  + '\n'
        mylibs.putftext('../metapack/'+pageName+'.i386', '#=== ' + pageName + ' ('+ lang+ ') ===> '+   out  + '\n')
        mylibs.putftext('../metapack/final/'+pageName+'-i386',   '\n'.join(packages_main))
        mylibs.putftext('../metapack/final/'+pageName+'-recommends-i386',   '\n'.join(packages_recommended))
        mylibs.putftext('../metapack/final/'+pageName+'-suggests-i386',   '\n'.join(packages_suggested))
        #print out_cat

